;coded by UEZ build 2016-04-21
#pragma compile(Icon, "c:\Program Files (x86)\AutoIt3\Icons\au3.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("MouseCoordMode", 2)

_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 400, $iH = 300, $iWh = $iW / 2, $iHh = $iH / 2, $sTitle = "GDI+ Particles - Repulsive Force Sim v1.0"
Global Const $fPi = ACos(-1), $fRad = $fPi / 180, $fDeg = 180 / $fPi

AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_Particles()

AutoItSetOption("GUIOnEventMode", 0)
_GDIPlus_Shutdown()


Func GDIPlus_Particles()
	$bExit = False
	$hGUI = GUICreate($sTitle, $iW, $iH) ;, 0, 0, $WS_POPUP)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local Const $hDC = _WinAPI_GetDC($hGUI)
	Local Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
	Local Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
	Local Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
	Local Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
	_GDIPlus_GraphicsSetSmoothingMode($hCanvas, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBrush_Clr = _GDIPlus_BrushCreateSolid(0xFF000000), _
				$hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0808080), _
				$hBrush_Particle = _GDIPlus_BrushCreateSolid(0xFFFFFFFF), _
				$hBrush_Field = _GDIPlus_BrushCreateSolid(0x80FF0000), _
				$hPen_Particle = _GDIPlus_PenCreate(0xFF404040), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 60, 16)

	$iFPS = 0

	Local $iPSize = 2, $iMinX = 0, $iMinY = 0, $iMaxX = $iW - $iPSize, $iMaxY = $iH - $iPSize, $iPAmount = 300, _
		  $fFieldRadius = 7500, $fFieldPower = 0.0075, $fAccel = 0.975, $fR = Sqrt(1.5 * $fFieldRadius)
	Local $dx, $dy, $vx, $vy, $x, $y, $r, $i, $impx, $impy, $b = True
	Local $tPData = DllStructCreate("struct;float x[" & $iPAmount & "];float y[" & $iPAmount & "];float mx[" & $iPAmount & "];float my[" & $iPAmount & "];endstruct")
	For $i = 1 To $iPAmount
		$tPData.x(($i)) = Random() * $iMaxX
		$tPData.y(($i)) = Random() * $iMaxY
		$tPData.mx(($i)) = 0
		$tPData.my(($i)) = 0
	Next

	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)

	Do
		DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $hCanvas, "handle", $hBrush_Clr, "float", 0, "float", 0, _
				"float", $iW, "float", $iH) ;erase canvas background


		$impx = MouseGetPos(0)
		$impy = MouseGetPos(1)
		For $i = 1 To $iPAmount
			$dx = $tPData.x(($i)) - $impx
			$dy = $tPData.y(($i)) - $impy
			$vx = $tPData.mx(($i))
			$vy = $tPData.my(($i))
			If ($dx * $dx) + ($dy * $dy) < $fFieldRadius Then
				$vx += $dx * $fFieldPower
				$vy += $dy * $fFieldPower
			EndIf
			$vx *= $fAccel
			$vy *= $fAccel
			$vx += Random() - 0.5
			$vy += Random() - 0.5
			$x = $tPData.x(($i)) + $vx
			$y = $tPData.y(($i)) + $vy
			If BitOR($x < 0, $x > $iMaxX, $y < 0, $y > $iMaxY) Then
				$r = ATan2($y - ($iMaxY / 2), $x - ($iMaxX / 2))
				$vx = -Cos($r)
				$vy = -Sin($r)
			EndIf
			$tPData.x(($i)) = $x
			$tPData.y(($i)) = $y
			$tPData.mx(($i)) = $vx
			$tPData.my(($i)) = $vy

			DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hCanvas, "handle", $hBrush_Particle, "float", _
					$tPData.x(($i)), "float", $tPData.y(($i)), "float", $iPSize, "float", $iPSize)
;~ 			DllCall($__g_hGDIPDll, "int", "GdipDrawEllipse", "handle", $hCanvas, "handle", $hPen_Particle, "float", _
;~ 					$tPData.x(($i)), "float", $tPData.y(($i)), "float", $iPSize, "float", $iPSize)

		Next

		DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hCanvas, "handle", $hBrush_Field, "float", _
				$impx - $fR / 2, "float", $impy - $fR / 2, "float", $fR, "float", $fR)

		_GDIPlus_GraphicsDrawStringEx($hCanvas, "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS)
		_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY) ;blit drawn bitmap to GUI

		If GUIGetCursorInfo($hGUI)[2] = 1 Then
			$fFieldRadius -= 100
			$fFieldRadius = $fFieldRadius < 100 ? 100 : $fFieldRadius
			$fR = Sqrt(1.5 * $fFieldRadius)
			$b = False
		Else
			If Not $b Then
				$fFieldRadius = 20000
				$b = True
			EndIf
		EndIf
		If $fFieldRadius > 7500 Then
			$fFieldRadius -= 100
			$fR = Sqrt(1.5 * $fFieldRadius)
		EndIf
;~ 		ConsoleWrite($fFieldRadius & @CRLF)

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_PenDispose($hPen_Particle)
	_GDIPlus_BrushDispose($hBrush_Clr)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_BrushDispose($hBrush_Particle)
	_GDIPlus_BrushDispose($hBrush_Field)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC_backbuffer, $DC_obj)
	_WinAPI_DeleteDC($hDC_backbuffer)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Particles

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS

Func ATan2($y, $x)
    Return (2 * ATan($y / ($x + Sqrt($x * $x + $y * $y))))
EndFunc